"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ONBOARDING_STATUS = exports.USER_ROLES = exports.TABLES = exports.supabaseAdmin = exports.supabase = void 0;
const supabase_js_1 = require("@supabase/supabase-js");
const dotenv_1 = __importDefault(require("dotenv"));
dotenv_1.default.config();
// Validate required environment variables
const requiredEnvVars = ['SUPABASE_URL', 'SUPABASE_ANON_KEY', 'SUPABASE_SERVICE_ROLE_KEY'];
for (const envVar of requiredEnvVars) {
    if (!process.env[envVar]) {
        throw new Error(`Missing required environment variable: ${envVar}`);
    }
}
// Create Supabase client with anon key (for client-side operations)
exports.supabase = (0, supabase_js_1.createClient)(process.env.SUPABASE_URL, process.env.SUPABASE_ANON_KEY);
// Create Supabase client with service role key (for admin operations)
exports.supabaseAdmin = (0, supabase_js_1.createClient)(process.env.SUPABASE_URL, process.env.SUPABASE_SERVICE_ROLE_KEY);
// Database table names
exports.TABLES = {
    USERS: 'users',
    VENDORS: 'vendors',
    CUSTOMERS: 'customers',
    SUBSCRIPTIONS: 'subscriptions',
    INVOICES: 'invoices',
    ORDERS: 'orders',
    PRODUCTS: 'products',
    MEASUREMENTS: 'measurements',
    NOTIFICATIONS: 'notifications'
};
// User roles
exports.USER_ROLES = {
    VENDOR: 'vendor',
    ADMIN: 'admin',
    STAFF: 'staff',
    SUPER_ADMIN: 'superadmin'
};
// Onboarding status
exports.ONBOARDING_STATUS = {
    INCOMPLETE: 'incomplete',
    COMPLETE: 'complete'
};
//# sourceMappingURL=supabase.js.map